<?php if(!defined('ABSPATH')) { die('You are not allowed to call this page directly.'); } ?>
<?php use memberpress\courses\models as models; ?>

<?php foreach($sections as $section) : ?>
  <div id="section<?php echo ((int) $section->section_order + 1); ?>" class="mpcs-section">
    <div class="mpcs-section-header">
      <div class="mpcs-section-title">
        <span class="mpcs-section-title-text"><?php echo esc_html($section->title); ?></span>
      </div>
      <?php if(!empty($section->description)) : ?>
        <div class="mpcs-section-description"><?php echo esc_html($section->description); ?></div>
      <?php endif; ?>
    </div> <!-- mpcs-section-header -->
    <div class="mpcs-lessons">
        <?php foreach($section->lessons(true, false) as $lesson_index => $lesson) : ?>
          <?php
            $lesson_available = $lesson->is_available();
            $has_completed_lesson = is_user_logged_in() && models\UserProgress::has_completed_lesson($current_user_id, $lesson->ID);

            if (models\Lesson::$cpt === $lesson->post_type) { ?>
              <div id="mpcs-lesson-<?php echo esc_attr($lesson->ID); ?>" class="mpcs-lesson <?php if(!$lesson_available) { echo "locked "; } ?>">
                <?php if($lesson_available) : ?>
                  <a href="<?php echo esc_url(get_permalink($lesson->ID)); ?>" class="mpcs-lesson-row-link">
                <?php else: ?>
                  <span class="mpcs-lesson-row-link">
                <?php endif; ?>
                  <div class="mpcs-lesson-progress">
                    <?php if($has_completed_lesson) : ?>
                      <span class="mpcs-lesson-complete"><i class="mpcs-ok-circled"></i></span>
                    <?php elseif($lesson_available) : ?>
                      <span class="mpcs-lesson-not-complete"><i class="mpcs-circle-regular"></i></span>
                    <?php else: ?>
                      <span class="mpcs-lesson-locked"><i class="mpcs-circle-regular"></i></span>
                    <?php endif; ?>
                  </div>
                  <div class="mpcs-lesson-link">
                    <?php echo esc_html($lesson->post_title); ?>
                    <?php do_action('mpcs_section_lesson_title_suffix', $lesson, $has_completed_lesson) ?>
                  </div>
                  <div class="mpcs-lesson-button">
                  <span class="mpcs-button" href="<?php echo esc_url(get_permalink($lesson->ID)); ?>">
                    <?php if($has_completed_lesson) : ?>
                      <span class="mpcs-button is-outline" href="<?php echo esc_url(get_permalink($lesson->ID)); ?>">
                        <?php esc_html_e('View', 'memberpress-courses') ?>
                      </span>
                    <?php elseif($lesson_available) : ?>
                      <span class="mpcs-button is-purple" href="<?php echo esc_url(get_permalink($lesson->ID)); ?>">
                        <?php esc_html_e('Start', 'memberpress-courses') ?>
                      </span>
                    <?php endif; ?>
                  </span>
                  </div>
                <?php if($lesson_available) : ?>
                  </a>
                <?php else: ?>
                  </span>
                <?php endif; ?>
              </div>
            <?php } else {
              do_action('mpcs_section_lesson_row', $lesson, $lesson_available, $has_completed_lesson, $is_sidebar, $show_bookmark, $next_lesson);
            }?>

        <?php endforeach; ?>
      </div> <!-- mpcs-lessons -->

  </div> <!-- mpcs-section -->
<?php endforeach; ?>
