<?php
/**
 * Plugin Name: User ID and Meta Column
 * Plugin URI: https://yourwebsite.com
 * Description: Adds User ID and a custom meta field (davor) columns to the Users admin page.
 * Version: 1.1
 * Author: Your Name
 * Author URI: https://yourwebsite.com
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Add new columns to the Users admin table.
function add_custom_user_columns( $columns ) {
    $columns['user_id'] = 'User ID';
    $columns['davor'] = 'Davor Meta';
    return $columns;
}
add_filter( 'manage_users_columns', 'add_custom_user_columns' );

// Populate the new columns with user IDs and custom meta values.
function show_custom_user_column_content( $value, $column_name, $user_id ) {
    if ( 'user_id' == $column_name ) {
        return $user_id;
    } elseif ( 'davor' == $column_name ) {
        $meta_value = get_user_meta( $user_id, 'davor', true );
        return $meta_value ? $meta_value : 'No Value';
    }
    return $value;
}
add_filter( 'manage_users_custom_column', 'show_custom_user_column_content', 10, 3 );

// Make the new columns sortable.
function make_custom_user_columns_sortable( $columns ) {
    $columns['user_id'] = 'ID';
    return $columns;
}
add_filter( 'manage_users_sortable_columns', 'make_custom_user_columns_sortable' );

?>
